﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCMEDHX")]

public partial class ucMedicalHx : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    private const long lPastMedicalHxInstrument = 3000;

    /// <summary>
    ///US:7264 event entry id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCMEDHXPatPWEventID"] != null)
            {
                strValue = Session["UCMEDHXPatPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["UCMEDHXPatPWEventID"] = Convert.ToString(value); }
    }

    /// <summary>
    ///US:7264 patient pathway id
    /// </summary>
    public string PatPWID
    {
        get
        {
            string strValue = "";
            if (Session["UCMEDHXPatPWID"] != null)
            {
                strValue = Session["UCMEDHXPatPWID"].ToString();
            }

            return strValue;
        }
        set { Session["UCMEDHXPatPWID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7264 page load of the medical history control
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        //pass on the BaseMaster to user controls
        ucTBICDSInstrument.BaseMstr = BaseMstr;

        if (!IsPostBack)
        {
            if (!X.IsAjaxRequest)
            {
                //reset the instruments user control
                ucTBICDSInstrument.m_lInstrumentID = 1;
                ucTBICDSInstrument.InitializeControl(BaseMstr.SelectedPatientID, BaseMstr.SiteID.ToString());
            }
        }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7264 initialize the medical history control
    /// </summary>
    /// <returns></returns>
    public bool InitializeControl(string strPatPWID, string strPatPWEventID)
    {
        //don't reload the if already loaded
        if (strPatPWEventID == PatPWEventID)
        {
            return true;
        }

        //keep the patient pathway event id
        PatPWEventID = strPatPWEventID;
        PatPWID = strPatPWID;

        return true; // LoadMedicalHX();
    }

  
    ///// <summary>
    ///// US:7264 load the medical history control
    ///// </summary>
    ///// <returns></returns>
    //protected bool LoadMedicalHX()
    //{
    //    //clear the current values
    //    lblMedHxData.Text = "";

    //    //get the latest medical hx record
    //    CPWEvent evt = new CPWEvent();
    //    DataSet dsMedHx = evt.GetMedicalHxDS(BaseMstr,
    //                                         BaseMstr.SelectedPatientID);
    //    if (!CDataUtils2.IsEmpty(dsMedHx))
    //    {
    //        //load the control
    //        lblMedHxData.Text = CDataUtils2.GetDSStringValue(dsMedHx, "med_hx_date");
    //    }

        
    //    return true;
    //}

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7264 load the medical history instrument
    /// </summary>
    /// <returns></returns>
    public ucTBICDSInstrument.InstrumentOptions LoadMedicalHXInstrument()
    {
        CPWEvent evt = new CPWEvent();
        long lIntakeID = 0;

        //get latest medical hx intake_id
        lIntakeID = evt.GetMedicalHxIntakeID(BaseMstr, BaseMstr.SelectedPatientID);

        ucTBICDSInstrument.InstrumentOptions result = ucTBICDSInstrument.LoadInstrument(BaseMstr.SelectedPatientID, 
                                                                                        BaseMstr.SiteID.ToString(), 
                                                                                        lPastMedicalHxInstrument,
                                                                                        lIntakeID,
                                                                                        0,
                                                                                        false);
        aspPnlPastMedicalHx.Update();

        return result;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7264 save the medical history 
    /// </summary>
    /// <returns></returns>
    //protected void OnMedHxOK(object sender, DirectEventArgs e)
    public ucTBICDSInstrument.AddInstrumentResponsesResult OnMedHxOK()
    {
        CPWEvent evt = new CPWEvent();

        ucTBICDSInstrument.AddInstrumentResponsesResult result = new ucTBICDSInstrument.AddInstrumentResponsesResult();

        if(evt.InsertMedicalHx(BaseMstr, 
                               CDataUtils2.ToLong(PatPWID),
                               CDataUtils2.ToLong(PatPWEventID)))
        {
            //LoadMedicalHX();
            string strAssessmentDate = "";
            string strAssessmentTime = "";
            result = ucTBICDSInstrument.AddInstrumentResponses(strAssessmentDate, strAssessmentTime);

            if (result.saved)
            {
                BaseMstr.ShowSystemFeedback("Medical History has been updated.", "Success!");
            }
            else
            {
                BaseMstr.ShowSystemFeedback(result.message, result.title);
            }
        }
        else
        {
            result.saved = false;
            BaseMstr.ShowSystemFeedback("An error occurred while saving medical history.", "Error saving medical history!");
        }

        return result;

    }
}